﻿#$baseURL = "https://192.168.2.136:4450/admin"
#$baseURL = "https://192.168.100.165:4450/admin"
$baseURL = "https://10.91.160.135:4450/admin"
$AdminUser = "admin"
$password = "alaska"

# Only to ignore certificates errors
add-type @"
    using System.Net;
    using System.Security.Cryptography.X509Certificates;

        public class IDontCarePolicy : ICertificatePolicy {
        public IDontCarePolicy() {}
        public bool CheckValidationResult(
            ServicePoint sPoint, X509Certificate cert,
            WebRequest wRequest, int certProb) {
            return true;
        }
    }
"@
[System.Net.ServicePointManager]::CertificatePolicy = new-object IDontCarePolicy 
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12


# authentication
$authBody = "{""userName"": ""$AdminUser"", ""password"": ""$password"", ""authType"": ""EFT""}"
$auth = Invoke-RestMethod -Uri "$baseURL/v1/authentication" -Method 'POST' -Body $authBody

$authToken = $auth.authToken
$authHeader = New-Object "System.Collections.Generic.Dictionary[[String],[String]]"
$authHeader.Add("Authorization", "EFTAdminAuthToken $authToken")

# Get sites
Write-Output "Site"
Write-Output "----"
$siteList = Invoke-RestMethod -Uri "$baseURL/v2/sites" -Method 'GET' -Headers $authHeader
Write-Output $siteList | ConvertTo-Json
foreach ($site in $siteList.data)
{
    Write-Output ("Site  $($site.id): $($site.attributes.name)")
}

$siteID = $siteList.data[0].id
##########
#Get User Permission Groups
Write-Output "Get User Permission Groups"
Write-Output "-----"
$userGroups = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/user-groups" -Method 'GET' -Headers $authHeader
Write-Output $userGroups | ConvertTo-Json -Depth 10


#######
###
#POST New Permission Group
Write-Output "POST User Permissions Group (New Permission Group)"
Write-Output "-----"
$update = 
'{
  "data": {
        "type": "userGroup",
        "attributes": {
            "name": "QA_API_User_Group_TEST"
        }
    }
}'

$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 10
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/user-groups" -Method 'POST' -Headers $authHeader -Body $update


############################
#Get User Permission Groups
$userGroups = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/user-groups" -Method 'GET' -Headers $authHeader
foreach ($userGroups in $userGroups.id)
{
    Write-Output ("User Permission Group found:  $($userGroups.id): $($userGroups.attributes.name)")
}
$userGroupID = $userGroups.data[3].id


#Get Specific User Permission Group
Write-Output "Get Specific User Permission Group"
Write-Output "-----"
$userGroup = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/user-groups/$userGroupID" -Method 'GET' -Headers $authHeader
Write-Output $userGroup | ConvertTo-Json -Depth 10

##################
#Get Specific User Permission Group
Write-Output "Get Specific User Permission Group"
Write-Output "-----"
$userGroup = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/user-groups/$userGroupID" -Method 'GET' -Headers $authHeader
Write-Output $userGroup | ConvertTo-Json -Depth 10

###
##Patch Specific User Permissions Group
Write-Output "User Permission Group Patch (update)"
Write-Output "-----"
$update = 
'{
   "data": {
    "type": "userGroup",
    "attributes": {
      "name": "QA_API_User_Group_TEST2"
    }
  }
}'
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 10
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/user-groups/$userGroupID" -Method 'PATCH' -Headers $authHeader -Body $update

####################################
#Get Specific User Permission Group
Write-Output "Get Specific User Permission Group"
Write-Output "-----"
$userGroup = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/user-groups/$userGroupID" -Method 'GET' -Headers $authHeader
Write-Output $userGroup | ConvertTo-Json -Depth 10

###
#DELETE Specific User Permission Group
Write-Output "Delete Specific User Permission Group"
Write-Output "-----"
$commandList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/user-groups/$userGroupID" -Method 'DELETE' -Headers $authHeader
Write-Output $commandList | ConvertTo-Json -Depth 10

#####################################
##
#Get User Permission Groups
$userGroups = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/user-groups" -Method 'GET' -Headers $authHeader
foreach ($userGroups in $userGroups.id)
{
   Write-Output ("User Permission Group found:  $($userGroups.id): $($userGroups.attributes.name)")
}
$userGroupID = $userGroups.data[3].id

###
#POST Selected User in Selected User Permission Group
Write-Output "POST (Add) User to Selected User Permissions Group"
Write-Output "-----"
$update = 
'{
  "data": [
    {
      "type": "user",
      "id": "b90be871-86ff-4060-b3cc-007903dff7f7"
    }
   ]
}'

$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 10
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/user-groups/$userGroupID/relationships/users" -Method 'POST' -Headers $authHeader -Body $update

########################################################
##
#Get User Permission Groups
$userGroups = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/user-groups" -Method 'GET' -Headers $authHeader
foreach ($userGroups in $userGroups.id)
{
   Write-Output ("User Permission Group found:  $($userGroups.id): $($userGroups.attributes.name)")
}
$userGroupID = $userGroups.data[3].id

#Delete User from User Permission Group
Write-Output "Deleting User from User Permission Group: "
Write-Output "-----"
$update = 
'{
  "data": [
    {
      "type": "user",
      "id": "b90be871-86ff-4060-b3cc-007903dff7f7"
    }
   ]
}'

$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 10
$commandList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/user-groups/$userGroupID/relationships/users" -Method 'DELETE' -Headers $authHeader -Body $update 



